**************************************************************************************************************************************************
******************* Code for 'Are Investment Tax Breaks Effective: Australian Evidence' *******************
***************************************************** Code for RDD regressions with lots of differnt bandwith - Appendix robustness******************************************************************

**************************************************DATE: Jun 2024 ******************************************************************************
*********************************************************************************************************************************************

 			local period =1 // counter for which obs we are looking at
			** Loop over differing periods for regressions
 foreach per in "& quarter== 1 & year==2010" "& quarter== 2 & year==2010"  "& quarter== 1 & year==2013" "& quarter== 2 & year==2013" "& quarter== 3 & year==2016" "& quarter== 4 & year==2016" "& quarter== 1 & year==2017" {
	clear 
	clear matrix
	use "$data\rdd_$ids.dta", clear

	keep if  income_l<$ubl2 & income_l>$lb2 & income> $lb2 `per' // focus relevant sample
capture drop treatment
capture drop sales2_t
capture drop sales2_2t
	
	** Make sure we have the relavant regressions varialbes for OLS-style set up
		capture g treatment = 1 if sales2_c<0 & sales2_c!=.
		replace treatment = 0 if sales2_c>0 & sales2_c!=.
		capture g sales2_t =  sales2_c*treatment
		capture g sales2_2t = sales2_2c*treatment
		compress
		** Differntt bandwidths with 10k increases
		local i = 50000
		quietly {
		while `i' <= 1000000 {
 
** Regressions with covariated
			areg lcapex treatment q_to_grow y_to  sales2_c sales2_t  if  sales2_c> -`i' & sales2_c<  `i'  , robust a(division)
 		** store results
			matrix b_1 = e(b)
			scalar bs_1 = b_1[1,1]
			matrix v_1 = e(V)
			scalar vs_1 = v_1[1,1]
			scalar bound_1 = sqrt(vs_1)*invttail(e(df_r),0.025)
			scalar ll_1 = bs_1 - bound_1 
			scalar ul_1 = bs_1 + bound_1
			scalar r_1  	= e(r2)
			** Version with quadratic form to account for SE bias
			areg lcapex treatment q_to_grow y_to sales2_c sales2_t sales2_2c sales2_2t  if  sales2_c> -`i' & sales2_c<  `i'  , robust a(division)
** store
			matrix b_2 = e(b)
			scalar bs_2 = b_2[1,1]
			matrix v_2 = e(V)
			scalar vs_2 = v_2[1,1]
			scalar bound_2 = sqrt(vs_2)*invttail(e(df_r),0.025)
			scalar ll_2 = bs_2 - bound_2 
			scalar ul_2 = bs_2 + bound_2
			scalar r_2 	= e(r2)

		
		** Bring together
			matrix bs = ( bs_1 \ bs_2 )
		
			matrix lls = ( ll_1 \ ll_2 )
		
			matrix uls = ( ul_1 \ ul_2 )
			
			matrix rs = ( r_1 \ r_2 )
			 
** Add in full matrix
			matrix B_`period' = (nullmat(B_`period'), bs)
			matrix LL_`period' = (nullmat(LL_`period'), lls)
			matrix UL_`period' = (nullmat(UL_`period'), uls)
			matrix N_`period' = (nullmat(N_`period'), e(N))
			matrix BW_`period' = (nullmat(BW_`period'), `i')
			matrix R_`period' = (nullmat(R_`period'), rs)


		
			local i = `i' +10000
		}
	}
 		
	**	Output	
	matrix B_`period' = matrix(B_`period')'
	matrix LL_`period' = matrix(LL_`period')'
	matrix UL_`period' = matrix(UL_`period')'
	matrix N_`period' = matrix(N_`period')'
	matrix BW_`period' = matrix(BW_`period')'
	matrix R_`period' = matrix(R_`period')'

	putexcel set "$savefile\BW_charts_$ids.xlsx", sheet(`period') modify
	putexcel A1=matrix(B_`period')
	putexcel D1=matrix(LL_`period')
	putexcel G1=matrix(UL_`period')
	putexcel J1=matrix(N_`period')
	putexcel M1=matrix(BW_`period')
	putexcel P1=matrix(R_`period')

		
	local period =`period'+1
	}
	
	
	 			local period =1
** Do for 10m turnover periods
 foreach per in  "& quarter== 1 & year==2017"  "& quarter== 2 & year==2017" {
clear
	clear matrix

	use "$data\rdd_$ids.dta", clear
	keep if  income_l<$ubl10 & income_l>$lb10 & income> $lb10 `per' 
capture drop treatment
capture drop sales10_t
capture drop sales10_2t
capture drop sales10_2c


	 g sales10_2c = sales10_c^2

	
		g treatment = 1 if sales10_c<0 & sales10_c!=.
		replace treatment = 0 if sales10_c>0 & sales10_c!=.
		 g sales10_t =  sales10_c*treatment
		 g sales10_2t = sales10_2c*treatment
		compress
		local period =1
		local i = 50000
		quietly {
		while `i' <= 1000000 {
 

			areg lcapex treatment q_to_grow y_to  sales10_c sales10_t  if  sales10_c> -`i' & sales10_c<  `i'  , robust a(division)
 		
			matrix b_1 = e(b)
			scalar bs_1 = b_1[1,1]
			matrix v_1 = e(V)
			scalar vs_1 = v_1[1,1]
			scalar bound_1 = sqrt(vs_1)*invttail(e(df_r),0.025)
			scalar ll_1 = bs_1 - bound_1 
			scalar ul_1 = bs_1 + bound_1
			scalar r_1 = e(r2)
			areg lcapex treatment q_to_grow y_to sales10_c sales10_t sales10_2c sales10_2t  if  sales10_c> -`i' & sales10_c<  `i'  , robust a(division)

			matrix b_2 = e(b)
			scalar bs_2 = b_2[1,1]
			matrix v_2 = e(V)
			scalar vs_2 = v_2[1,1]
			scalar bound_2 = sqrt(vs_2)*invttail(e(df_r),0.025)
			scalar ll_2 = bs_2 - bound_2 
			scalar ul_2 = bs_2 + bound_2
			scalar r_2 = e(r2)
		
			matrix bs = ( bs_1 \ bs_2 )
		
			matrix lls = ( ll_1 \ ll_2 )
		
			matrix uls = ( ul_1 \ ul_2 )
			 matrix rs = ( r_1 \ r_2 )

			matrix B_`period' = (nullmat(B_`period'), bs)
			matrix LL_`period' = (nullmat(LL_`period'), lls)
			matrix UL_`period' = (nullmat(UL_`period'), uls)
			matrix N_`period' = (nullmat(N_`period'), e(N))
			matrix BW_`period' = (nullmat(BW_`period'), `i')
			matrix R_`period' = (nullmat(R_`period'), rs)


		
			local i = `i' +10000
		}
	}
 		
			
	matrix B_`period' = matrix(B_`period')'
	matrix LL_`period' = matrix(LL_`period')'
	matrix UL_`period' = matrix(UL_`period')'
	matrix N_`period' = matrix(N_`period')'
	matrix BW_`period' = matrix(BW_`period')'
	matrix R_`period' = matrix(R_`period')'

	putexcel set "$savefile\BW_charts_$ids.xlsx", sheet(`per'_10) modify
	putexcel A1=matrix(B_`period')
	putexcel D1=matrix(LL_`period')
	putexcel G1=matrix(UL_`period')
	putexcel J1=matrix(N_`period')
	putexcel M1=matrix(BW_`period')
	putexcel Q1=matrix(R_`period')

		
	local period =`period'+1
	}


	
